<?php

namespace App\Http\Middleware;

use App\Traits\ApiValidation;
use Closure;
use Illuminate\Http\Request;

class CheckModuleApi
{
    use ApiValidation;

    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, $role)
    {
        if (basicControl()->{$role} == 0) {
            return response()->json($this->withErrors('Module currently unreachable'));
        }
        return $next($request);
    }
}
