<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $gateways = array(
            array('id' => '1','code' => 'paypal','name' => 'Paypal','sort_by' => '10','image' => 'gateway/97w3d4dpqwAhYuhFIqLEfBnkSE4rYIpd8sBdFiBN.jpg','driver' => 'local','status' => '1','parameters' => '{"cleint_id":"","secret":""}','currencies' => '{"0":{"AUD":"AUD","BRL":"BRL","CAD":"CAD","CZK":"CZK","DKK":"DKK","EUR":"EUR","HKD":"HKD","HUF":"HUF","INR":"INR","ILS":"ILS","JPY":"JPY","MYR":"MYR","MXN":"MXN","TWD":"TWD","NZD":"NZD","NOK":"NOK","PHP":"PHP","PLN":"PLN","GBP":"GBP","RUB":"RUB","SGD":"SGD","SEK":"SEK","CHF":"CHF","THB":"THB","USD":"USD"}}','extra_parameters' => NULL,'supported_currency' => '["AUD"]','receivable_currencies' => '[{"name":"AUD","currency_symbol":"AUD","conversion_rate":"0.14","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '1','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-06-01 16:11:27'),
            array('id' => '2','code' => 'stripe','name' => 'Stripe ','sort_by' => '5','image' => 'gateway/rrG6S6yZD4oKP5fQzJhdZhpsCONhiYGjPRR6ormL.jpg','driver' => 'local','status' => '1','parameters' => '{"secret_key":"sk_test_aat3tzBCCXXBkS4sxY3M8A1B","publishable_key":"pk_test_AU3G7doZ1sbdpJLj0NaozPBu"}','currencies' => '{"0":{"USD":"USD","AUD":"AUD","BRL":"BRL","CAD":"CAD","CHF":"CHF","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","INR":"INR","JPY":"JPY","MXN":"MXN","MYR":"MYR","NOK":"NOK","NZD":"NZD","PLN":"PLN","SEK":"SEK","SGD":"SGD"}}','extra_parameters' => NULL,'supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.0085","min_limit":"1","max_limit":"10000","percentage_charge":"10","fixed_charge":"1"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '1','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-06-04 18:31:19'),
            array('id' => '3','code' => 'skrill','name' => 'Skrill','sort_by' => '3','image' => 'gateway/vZvM3TU5r4X9ocSUZjajQjZ97zLmoaxEKwrNaWjI.jpg','driver' => 'local','status' => '0','parameters' => '{"pay_to_email":"","secret_key":""}','currencies' => '{"0":{"AED":"AED","AUD":"AUD","BGN":"BGN","BHD":"BHD","CAD":"CAD","CHF":"CHF","CZK":"CZK","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","HRK":"HRK","HUF":"HUF","ILS":"ILS","INR":"INR","ISK":"ISK","JOD":"JOD","JPY":"JPY","KRW":"KRW","KWD":"KWD","MAD":"MAD","MYR":"MYR","NOK":"NOK","NZD":"NZD","OMR":"OMR","PLN":"PLN","QAR":"QAR","RON":"RON","RSD":"RSD","SAR":"SAR","SEK":"SEK","SGD":"SGD","THB":"THB","TND":"TND","TRY":"TRY","TWD":"TWD","USD":"USD","ZAR":"ZAR","COP":"COP"}}','extra_parameters' => NULL,'supported_currency' => '["AUD"]','receivable_currencies' => '[{"name":"AUD","currency_symbol":"AUD","conversion_rate":"0.014","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:01'),
            array('id' => '4','code' => 'perfectmoney','name' => 'Perfect Money','sort_by' => '8','image' => 'gateway/4GXuYzWoISaXisdg5cWpysMgI7WKIlh5WPvPg7XK.jpg','driver' => 'local','status' => '0','parameters' => '{"passphrase":"","payee_account":""}','currencies' => '{"0":{"USD":"USD","EUR":"EUR"}}','extra_parameters' => NULL,'supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.0091","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:01'),
            array('id' => '5','code' => 'paytm','name' => 'PayTM','sort_by' => '29','image' => 'gateway/BJxatcNgR5D7aFWpHfZFtVduNZBBytj7rfYeWVHo.jpg','driver' => 'local','status' => '0','parameters' => '{"MID":"","merchant_key":"","WEBSITE":"","INDUSTRY_TYPE_ID":"","CHANNEL_ID":""}','currencies' => '{"0":{"AUD":"AUD","ARS":"ARS","BDT":"BDT","BRL":"BRL","BGN":"BGN","CAD":"CAD","CLP":"CLP","CNY":"CNY","COP":"COP","HRK":"HRK","CZK":"CZK","DKK":"DKK","EGP":"EGP","EUR":"EUR","GEL":"GEL","GHS":"GHS","HKD":"HKD","HUF":"HUF","INR":"INR","IDR":"IDR","ILS":"ILS","JPY":"JPY","KES":"KES","MYR":"MYR","MXN":"MXN","MAD":"MAD","NPR":"NPR","NZD":"NZD","NGN":"NGN","NOK":"NOK","PKR":"PKR","PEN":"PEN","PHP":"PHP","PLN":"PLN","RON":"RON","RUB":"RUB","SGD":"SGD","ZAR":"ZAR","KRW":"KRW","LKR":"LKR","SEK":"SEK","CHF":"CHF","THB":"THB","TRY":"TRY","UGX":"UGX","UAH":"UAH","AED":"AED","GBP":"GBP","USD":"USD","VND":"VND","XOF":"XOF"}}','extra_parameters' => NULL,'supported_currency' => '["AUD"]','receivable_currencies' => '[{"name":"AUD","currency_symbol":"AUD","conversion_rate":"0.014","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '6','code' => 'payeer','name' => 'Payeer','sort_by' => '25','image' => 'gateway/ahwMLvV0kq29xJfnPmMThSFAiaVmaiLjxrPP7GDt.png','driver' => 'local','status' => '0','parameters' => '{"merchant_id":"","secret_key":""}','currencies' => '{"0":{"USD":"USD","EUR":"EUR","RUB":"RUB"}}','extra_parameters' => '{"status":"ipn"}','supported_currency' => '["USD","AUD"]','receivable_currencies' => NULL,'description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '7','code' => 'paystack','name' => 'PayStack','sort_by' => '6','image' => 'gateway/EG1VmV65NyuZmB20ZJiouMfk2kfQAIreZun7S47U.jpg','driver' => 'local','status' => '0','parameters' => '{"public_key":"","secret_key":""}','currencies' => '{"0":{"USD":"USD","NGN":"NGN"}}','extra_parameters' => '{"callback":"ipn","webhook":"ipn"}
','supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.0091","min_limit":"1","max_limit":"10000","percentage_charge":"0.1","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => 'live','is_manual' => NULL,'note' => NULL,'is_subscription' => '1','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:01'),
            array('id' => '8','code' => 'voguepay','name' => 'VoguePay','sort_by' => '34','image' => 'gateway/fcz0uSqZIDflFm1KZecCNdttriwuN21PDKyvKMHE.jpg','driver' => 'local','status' => '0','parameters' => '{"merchant_id":""}','currencies' => '{"0":{"NGN":"NGN","USD":"USD","EUR":"EUR","GBP":"GBP","ZAR":"ZAR","JPY":"JPY","INR":"INR","AUD":"AUD","CAD":"CAD","NZD":"NZD","NOK":"NOK","PLN":"PLN"}}








','extra_parameters' => NULL,'supported_currency' => '["NGN"]','receivable_currencies' => '[{"name":"NGN","currency_symbol":"NGN","conversion_rate":"7.6","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '9','code' => 'flutterwave','name' => 'Flutterwave','sort_by' => '2','image' => 'gateway/cXk3X7NKTAHOV4oljJfAadpSRlsaif.avif','driver' => 'local','status' => '1','parameters' => '{"public_key":"","secret_key":"","encryption_key":""}','currencies' => '{"0":{"KES":"KES","GHS":"GHS","NGN":"NGN","USD":"USD","GBP":"GBP","EUR":"EUR","UGX":"UGX","TZS":"TZS"}}','extra_parameters' => NULL,'supported_currency' => '["GHS","NGN","USD"]','receivable_currencies' => '[{"name":"GHS","currency_symbol":"GHS","conversion_rate":"0.67","min_limit":"1","max_limit":"500000","percentage_charge":"0.00","fixed_charge":"0.5"},{"name":"NGN","currency_symbol":"NGN","conversion_rate":"0.14","min_limit":"1","max_limit":"500000","percentage_charge":"0.00","fixed_charge":"0.5"},{"name":"USD","currency_symbol":"USD","conversion_rate":"1","min_limit":"1","max_limit":"10000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-06-01 16:11:16'),
            array('id' => '10','code' => 'razorpay','name' => 'RazorPay','sort_by' => '4','image' => 'gateway/6PsaJkhHOpdB3xXzL6ZOCh96W2C1QUHJM9MDDxue.jpg','driver' => 'local','status' => '1','parameters' => '{"key_id":"","key_secret":""}','currencies' => '{"0":{"INR":"INR"}}','extra_parameters' => NULL,'supported_currency' => '["INR"]','receivable_currencies' => '[{"name":"INR","currency_symbol":"IND","conversion_rate":"0.76","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.2"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '1','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-06-01 16:11:23'),
            array('id' => '11','code' => 'instamojo','name' => 'instamojo','sort_by' => '13','image' => 'gateway/f0ms4fxXmDLbUdix3DIZMIN7e4zZmBGSN0HdTt9W.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":"","auth_token":"","salt":""}','currencies' => '{"0":{"INR":"INR"}}','extra_parameters' => NULL,'supported_currency' => '["INR"]','receivable_currencies' => '[{"name":"INR","currency_symbol":"INR","conversion_rate":"0.87","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"1.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '12','code' => 'mollie','name' => 'Mollie','sort_by' => '20','image' => 'gateway/3q04fCkcqXUTihufkK1eCmzMJhBaDctgiErZ8TiJ.png','driver' => 'local','status' => '0','parameters' => '{"api_key":""}','currencies' => '{"0":{"AED":"AED","AUD":"AUD","BGN":"BGN","BRL":"BRL","CAD":"CAD","CHF":"CHF","CZK":"CZK","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","HRK":"HRK","HUF":"HUF","ILS":"ILS","ISK":"ISK","JPY":"JPY","MXN":"MXN","MYR":"MYR","NOK":"NOK","NZD":"NZD","PHP":"PHP","PLN":"PLN","RON":"RON","RUB":"RUB","SEK":"SEK","SGD":"SGD","THB":"THB","TWD":"TWD","USD":"USD","ZAR":"ZAR"}}','extra_parameters' => NULL,'supported_currency' => '["AUD"]','receivable_currencies' => '[{"name":"AUD","currency_symbol":"AUD","conversion_rate":"0.091","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '13','code' => 'twocheckout','name' => '2checkout','sort_by' => '11','image' => 'gateway/2AAwV6ShfNT63vUgB5DZm8W62WpACY4YJFhKA02d.jpg','driver' => 'local','status' => '0','parameters' => '{"merchant_code":"","secret_key":""}','currencies' => '{"0":{"AFN":"AFN","ALL":"ALL","DZD":"DZD","ARS":"ARS","AUD":"AUD","AZN":"AZN","BSD":"BSD","BDT":"BDT","BBD":"BBD","BZD":"BZD","BMD":"BMD","BOB":"BOB","BWP":"BWP","BRL":"BRL","GBP":"GBP","BND":"BND","BGN":"BGN","CAD":"CAD","CLP":"CLP","CNY":"CNY","COP":"COP","CRC":"CRC","HRK":"HRK","CZK":"CZK","DKK":"DKK","DOP":"DOP","XCD":"XCD","EGP":"EGP","EUR":"EUR","FJD":"FJD","GTQ":"GTQ","HKD":"HKD","HNL":"HNL","HUF":"HUF","INR":"INR","IDR":"IDR","ILS":"ILS","JMD":"JMD","JPY":"JPY","KZT":"KZT","KES":"KES","LAK":"LAK","MMK":"MMK","LBP":"LBP","LRD":"LRD","MOP":"MOP","MYR":"MYR","MVR":"MVR","MRO":"MRO","MUR":"MUR","MXN":"MXN","MAD":"MAD","NPR":"NPR","TWD":"TWD","NZD":"NZD","NIO":"NIO","NOK":"NOK","PKR":"PKR","PGK":"PGK","PEN":"PEN","PHP":"PHP","PLN":"PLN","QAR":"QAR","RON":"RON","RUB":"RUB","WST":"WST","SAR":"SAR","SCR":"SCR","SGD":"SGD","SBD":"SBD","ZAR":"ZAR","KRW":"KRW","LKR":"LKR","SEK":"SEK","CHF":"CHF","SYP":"SYP","THB":"THB","TOP":"TOP","TTD":"TTD","TRY":"TRY","UAH":"UAH","AED":"AED","USD":"USD","VUV":"VUV","VND":"VND","XOF":"XOF","YER":"YER"}}','extra_parameters' => '{"approved_url":"ipn"}','supported_currency' => '["AFN"]','receivable_currencies' => '[{"name":"AFN","currency_symbol":"AFN","conversion_rate":"0.72","min_limit":"1","max_limit":"10000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '14','code' => 'authorizenet','name' => 'Authorize.Net','sort_by' => '7','image' => 'gateway/kAn32PIQ7BKxYJPeYMwQtIYdAMAvZ8g1v4OuIhse.jpg','driver' => 'local','status' => '0','parameters' => '{"login_id":"","current_transaction_key":""}','currencies' => '{"0":{"AUD":"AUD","CAD":"CAD","CHF":"CHF","DKK":"DKK","EUR":"EUR","GBP":"GBP","NOK":"NOK","NZD":"NZD","PLN":"PLN","SEK":"SEK","USD":"USD"}}','extra_parameters' => NULL,'supported_currency' => '["AUD"]','receivable_currencies' => '[{"name":"AUD","currency_symbol":"AUD","conversion_rate":"0.14","min_limit":"1","max_limit":"100000","percentage_charge":"0.5","fixed_charge":"0.2"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:01'),
            array('id' => '15','code' => 'securionpay','name' => 'SecurionPay','sort_by' => '33','image' => 'gateway/jjTofo4wIOhVdcf1l5iJum7RUJd2xyohknA54T5L.jpg','driver' => 'local','status' => '0','parameters' => '{"public_key":"","secret_key":""}','currencies' => '{"0":{"AFN":"AFN", "DZD":"DZD", "ARS":"ARS", "AUD":"AUD", "BHD":"BHD", "BDT":"BDT", "BYR":"BYR", "BAM":"BAM", "BWP":"BWP", "BRL":"BRL", "BND":"BND", "BGN":"BGN", "CAD":"CAD", "CLP":"CLP", "CNY":"CNY", "COP":"COP", "KMF":"KMF", "HRK":"HRK", "CZK":"CZK", "DKK":"DKK", "DJF":"DJF", "DOP":"DOP", "EGP":"EGP", "ETB":"ETB", "ERN":"ERN", "EUR":"EUR", "GEL":"GEL", "HKD":"HKD", "HUF":"HUF", "ISK":"ISK", "INR":"INR", "IDR":"IDR", "IRR":"IRR", "IQD":"IQD", "ILS":"ILS", "JMD":"JMD", "JPY":"JPY", "JOD":"JOD", "KZT":"KZT", "KES":"KES", "KWD":"KWD", "KGS":"KGS", "LVL":"LVL", "LBP":"LBP", "LTL":"LTL", "MOP":"MOP", "MKD":"MKD", "MGA":"MGA", "MWK":"MWK", "MYR":"MYR", "MUR":"MUR", "MXN":"MXN", "MDL":"MDL", "MAD":"MAD", "MZN":"MZN", "NAD":"NAD", "NPR":"NPR", "ANG":"ANG", "NZD":"NZD", "NOK":"NOK", "OMR":"OMR", "PKR":"PKR", "PEN":"PEN", "PHP":"PHP", "PLN":"PLN", "QAR":"QAR", "RON":"RON", "RUB":"RUB", "SAR":"SAR", "RSD":"RSD", "SGD":"SGD", "ZAR":"ZAR", "KRW":"KRW", "IKR":"IKR", "LKR":"LKR", "SEK":"SEK", "CHF":"CHF", "SYP":"SYP", "TWD":"TWD", "TZS":"TZS", "THB":"THB", "TND":"TND", "TRY":"TRY", "UAH":"UAH", "AED":"AED", "GBP":"GBP", "USD":"USD", "VEB":"VEB", "VEF":"VEF", "VND":"VND", "XOF":"XOF", "YER":"YER", "ZMK":"ZMK"}}','extra_parameters' => NULL,'supported_currency' => '["AFN"]','receivable_currencies' => '[{"name":"AFN","currency_symbol":"AFN","conversion_rate":"1.2","min_limit":"1","max_limit":"10000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '16','code' => 'payumoney','name' => 'PayUmoney','sort_by' => '30','image' => 'gateway/hOjHGVl6oUSQjkNrFuHhwPbrzdTrWdzM4jdeHtYJ.jpg','driver' => 'local','status' => '0','parameters' => '{"merchant_key":"","salt":""}','currencies' => '{"0":{"INR":"INR"}}','extra_parameters' => NULL,'supported_currency' => '["INR"]','receivable_currencies' => '[{"name":"INR","currency_symbol":"INR","conversion_rate":"1.32","min_limit":"1","max_limit":"200000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '17','code' => 'mercadopago','name' => 'Mercado Pago','sort_by' => '18','image' => 'gateway/FlltshrQjItTqAO4kHcxKlPOgWZPx9BUEtstH00o.jpg','driver' => 'local','status' => '0','parameters' => '{"access_token":""}','currencies' => '{"0":{"ARS":"ARS","BOB":"BOB","BRL":"BRL","CLF":"CLF","CLP":"CLP","COP":"COP","CRC":"CRC","CUC":"CUC","CUP":"CUP","DOP":"DOP","EUR":"EUR","GTQ":"GTQ","HNL":"HNL","MXN":"MXN","NIO":"NIO","PAB":"PAB","PEN":"PEN","PYG":"PYG","USD":"USD","UYU":"UYU","VEF":"VEF","VES":"VES"}}','extra_parameters' => NULL,'supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.0091","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '18','code' => 'coingate','name' => 'Coingate','sort_by' => '22','image' => 'gateway/ALENryEcR40tYh8SAwybQZTBeFvqi2DIM2l9G3Nd.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":""}','currencies' => '{"0":{"USD":"USD","EUR":"EUR"}}','extra_parameters' => NULL,'supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.098","min_limit":"1","max_limit":"100000","percentage_charge":"0.00","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '19','code' => 'coinbasecommerce','name' => 'Coinbase Commerce','sort_by' => '21','image' => 'gateway/1tQ5Q3N4xORqG2fliNzfgKnF30yITmTa6UvkXGhe.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":"","secret":""}','currencies' => '{"0":{"AED":"AED","AFN":"AFN","ALL":"ALL","AMD":"AMD","ANG":"ANG","AOA":"AOA","ARS":"ARS","AUD":"AUD","AWG":"AWG","AZN":"AZN","BAM":"BAM","BBD":"BBD","BDT":"BDT","BGN":"BGN","BHD":"BHD","BIF":"BIF","BMD":"BMD","BND":"BND","BOB":"BOB","BRL":"BRL","BSD":"BSD","BTN":"BTN","BWP":"BWP","BYN":"BYN","BZD":"BZD","CAD":"CAD","CDF":"CDF","CHF":"CHF","CLF":"CLF","CLP":"CLP","CNY":"CNY","COP":"COP","CRC":"CRC","CUC":"CUC","CUP":"CUP","CVE":"CVE","CZK":"CZK","DJF":"DJF","DKK":"DKK","DOP":"DOP","DZD":"DZD","EGP":"EGP","ERN":"ERN","ETB":"ETB","EUR":"EUR","FJD":"FJD","FKP":"FKP","GBP":"GBP","GEL":"GEL","GGP":"GGP","GHS":"GHS","GIP":"GIP","GMD":"GMD","GNF":"GNF","GTQ":"GTQ","GYD":"GYD","HKD":"HKD","HNL":"HNL","HRK":"HRK","HTG":"HTG","HUF":"HUF","IDR":"IDR","ILS":"ILS","IMP":"IMP","INR":"INR","IQD":"IQD","IRR":"IRR","ISK":"ISK","JEP":"JEP","JMD":"JMD","JOD":"JOD","JPY":"JPY","KES":"KES","KGS":"KGS","KHR":"KHR","KMF":"KMF","KPW":"KPW","KRW":"KRW","KWD":"KWD","KYD":"KYD","KZT":"KZT","LAK":"LAK","LBP":"LBP","LKR":"LKR","LRD":"LRD","LSL":"LSL","LYD":"LYD","MAD":"MAD","MDL":"MDL","MGA":"MGA","MKD":"MKD","MMK":"MMK","MNT":"MNT","MOP":"MOP","MRO":"MRO","MUR":"MUR","MVR":"MVR","MWK":"MWK","MXN":"MXN","MYR":"MYR","MZN":"MZN","NAD":"NAD","NGN":"NGN","NIO":"NIO","NOK":"NOK","NPR":"NPR","NZD":"NZD","OMR":"OMR","PAB":"PAB","PEN":"PEN","PGK":"PGK","PHP":"PHP","PKR":"PKR","PLN":"PLN","PYG":"PYG","QAR":"QAR","RON":"RON","RSD":"RSD","RUB":"RUB","RWF":"RWF","SAR":"SAR","SBD":"SBD","SCR":"SCR","SDG":"SDG","SEK":"SEK","SGD":"SGD","SHP":"SHP","SLL":"SLL","SOS":"SOS","SRD":"SRD","SSP":"SSP","STD":"STD","SVC":"SVC","SYP":"SYP","SZL":"SZL","THB":"THB","TJS":"TJS","TMT":"TMT","TND":"TND","TOP":"TOP","TRY":"TRY","TTD":"TTD","TWD":"TWD","TZS":"TZS","UAH":"UAH","UGX":"UGX","USD":"USD","UYU":"UYU","UZS":"UZS","VEF":"VEF","VND":"VND","VUV":"VUV","WST":"WST","XAF":"XAF","XAG":"XAG","XAU":"XAU","XCD":"XCD","XDR":"XDR","XOF":"XOF","XPD":"XPD","XPF":"XPF","XPT":"XPT","YER":"YER","ZAR":"ZAR","ZMW":"ZMW","ZWL":"ZWL"}}','extra_parameters' => '{"webhook":"ipn"}','supported_currency' => '["AED"]','receivable_currencies' => '[{"name":"AED","currency_symbol":"AUD","conversion_rate":"0.016","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '20','code' => 'monnify','name' => 'Monnify','sort_by' => '23','image' => 'gateway/f6DYd1wdk57CA2bf0O08g2sUQEXUrSO1MZwqruHw.png','driver' => 'local','status' => '0','parameters' => '{"api_key":"","secret_key":"","contract_code":""}','currencies' => '{"0":{"NGN":"NGN"}}','extra_parameters' => NULL,'supported_currency' => '["NGN"]','receivable_currencies' => '[{"name":"NGN","currency_symbol":"NGN","conversion_rate":"7.9","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '21','code' => 'blockio','name' => 'Block.io','sort_by' => '15','image' => 'gateway/p4TbkcZIzXFDEo0SNYadwD6qUuSfSTZSomtQDLGg.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":"","api_pin":""}','currencies' => '{"1":{"BTC":"BTC","LTC":"LTC","DOGE":"DOGE"}}','extra_parameters' => '{"cron":"ipn"}','supported_currency' => '["BTC"]','receivable_currencies' => '[{"name":"BTC","currency_symbol":"BTC","conversion_rate":"0.00000123","min_limit":"1","max_limit":"500000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '22','code' => 'coinpayments','name' => 'CoinPayments','sort_by' => '27','image' => 'gateway/kBB31brJLejfBCaksrLeDx5EjOx3rxsZFjlBq9EA.jpg','driver' => 'local','status' => '0','parameters' => '{"merchant_id":"","private_key":"","public_key":""}','currencies' => '{"0":{"USD":"USD","AUD":"AUD","BRL":"BRL","CAD":"CAD","CHF":"CHF","CLP":"CLP","CNY":"CNY","DKK":"DKK","EUR":"EUR","GBP":"GBP","HKD":"HKD","INR":"INR","ISK":"ISK","JPY":"JPY","KRW":"KRW","NZD":"NZD","PLN":"PLN","RUB":"RUB","SEK":"SEK","SGD":"SGD","THB":"THB","TWD":"TWD"},"1":{"BTC":"Bitcoin","BTC.LN":"Bitcoin (Lightning Network)","LTC":"Litecoin","CPS":"CPS Coin","VLX":"Velas","APL":"Apollo","AYA":"Aryacoin","BAD":"Badcoin","BCD":"Bitcoin Diamond","BCH":"Bitcoin Cash","BCN":"Bytecoin","BEAM":"BEAM","BITB":"Bean Cash","BLK":"BlackCoin","BSV":"Bitcoin SV","BTAD":"Bitcoin Adult","BTG":"Bitcoin Gold","BTT":"BitTorrent","CLOAK":"CloakCoin","CLUB":"ClubCoin","CRW":"Crown","CRYP":"CrypticCoin","CRYT":"CryTrExCoin","CURE":"CureCoin","DASH":"DASH","DCR":"Decred","DEV":"DeviantCoin","DGB":"DigiByte","DOGE":"Dogecoin","EBST":"eBoost","EOS":"EOS","ETC":"Ether Classic","ETH":"Ethereum","ETN":"Electroneum","EUNO":"EUNO","EXP":"EXP","Expanse":"Expanse","FLASH":"FLASH","GAME":"GameCredits","GLC":"Goldcoin","GRS":"Groestlcoin","KMD":"Komodo","LOKI":"LOKI","LSK":"LSK","MAID":"MaidSafeCoin","MUE":"MonetaryUnit","NAV":"NAV Coin","NEO":"NEO","NMC":"Namecoin","NVST":"NVO Token","NXT":"NXT","OMNI":"OMNI","PINK":"PinkCoin","PIVX":"PIVX","POT":"PotCoin","PPC":"Peercoin","PROC":"ProCurrency","PURA":"PURA","QTUM":"QTUM","RES":"Resistance","RVN":"Ravencoin","RVR":"RevolutionVR","SBD":"Steem Dollars","SMART":"SmartCash","SOXAX":"SOXAX","STEEM":"STEEM","STRAT":"STRAT","SYS":"Syscoin","TPAY":"TokenPay","TRIGGERS":"Triggers","TRX":" TRON","UBQ":"Ubiq","UNIT":"UniversalCurrency","USDT":"Tether USD (Omni Layer)","VTC":"Vertcoin","WAVES":"Waves","XCP":"Counterparty","XEM":"NEM","XMR":"Monero","XSN":"Stakenet","XSR":"SucreCoin","XVG":"VERGE","XZC":"ZCoin","ZEC":"ZCash","ZEN":"Horizen"}}','extra_parameters' => '{"callback":"ipn"}','supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.01","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '23','code' => 'blockchain','name' => 'Blockchain','sort_by' => '16','image' => 'gateway/6485AeUpE2e8iu51zDKvkwVDkIc9UKInEtK76gz7.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":"","xpub_code":""}','currencies' => '{"1":{"BTC":"BTC"}}','extra_parameters' => NULL,'supported_currency' => '["BTC"]','receivable_currencies' => '[{"name":"BTC","currency_symbol":"BTC","conversion_rate":"0.0000123","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '24','code' => 'cashmaal','name' => 'cashmaal','sort_by' => '19','image' => 'gateway/0gz1EhbGkF8lfGcNeHKGqz0y1LaE8IOBuymZ4Fc4.jpg','driver' => 'local','status' => '0','parameters' => '{"web_id":"","ipn_key":""}','currencies' => '{"0":{"PKR":"PKR","USD":"USD"}}','extra_parameters' => '{"ipn_url":"ipn"}','supported_currency' => '["PKR"]','receivable_currencies' => '[{"name":"PKR","currency_symbol":"PKR","conversion_rate":"2.37","min_limit":"1","max_limit":"10000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => NULL,'updated_at' => '2024-02-25 18:12:02'),
            array('id' => '25','code' => 'midtrans','name' => 'Midtrans','sort_by' => '1','image' => 'gateway/ZHeHf9yvWcqLJ6XZVCkhXIJQvU7pYOAzGGq5ziMT.png','driver' => 'local','status' => '0','parameters' => '{"client_key":"","server_key":""}','currencies' => '{"0":{"IDR":"IDR"}}','extra_parameters' => '{"payment_notification_url":"ipn", "finish redirect_url":"ipn", "unfinish redirect_url":"failed","error redirect_url":"failed"}','supported_currency' => '["IDR"]','receivable_currencies' => '[{"name":"IDR","currency_symbol":"IDR","conversion_rate":"85","min_limit":"1","max_limit":"5000000","percentage_charge":"1.2","fixed_charge":"0.6"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => 'live','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:01'),
            array('id' => '26','code' => 'peachpayments','name' => 'peachpayments','sort_by' => '35','image' => 'gateway/nIcAEOjT21dyxM6URL1QvkazNpSyqVzJQk7LRFF8.png','driver' => 'local','status' => '0','parameters' => '{"Authorization_Bearer":"","Entity_ID":"","Recur_Channel":""}','currencies' => '{"0":{"AED":"AED","AFA":"AFA","AMD":"AMD","ANG":"ANG","AOA":"AOA","ARS":"ARS","AUD":"AUD","AWG":"AWG","AZM":"AZM","BAM":"BAM","BBD":"BBD","BDT":"BDT","BGN":"BGN","BHD":"BHD","BIF":"BIF","BMD":"BMD","BND":"BND","BOB":"BOB","BRL":"BRL","BSD":"BSD","BTN":"BTN","BWP":"BWP","BYR":"BYR","BZD":"BZD","CAD":"CAD","CDF":"CDF","CHF":"CHF","CLP":"CLP","CNY":"CNY","COP":"COP","CRC":"CRC","CUP":"CUP","CVE":"CVE","CYP":"CYP","CZK":"CZK","DJF":"DJF","DKK":"DKK","DOP":"DOP","DZD":"DZD","EEK":"EEK","EGP":"EGP","ERN":"ERN","ETB":"ETB","EUR":"EUR","FJD":"FJD","FKP":"FKP","GBP":"GBP","GEL":"GEL","GGP":"GGP","GHC":"GHC","GIP":"GIP","GMD":"GMD","GNF":"GNF","GTQ":"GTQ","GYD":"GYD","HKD":"HKD","HNL":"HNL","HRK":"HRK","HTG":"HTG","HUF":"HUF","IDR":"IDR","ILS":"ILS","IMP":"IMP","INR":"INR","IQD":"IQD","IRR":"IRR","ISK":"ISK","JEP":"JEP","JMD":"JMD","JOD":"JOD","JPY":"JPY","KES":"KES","KGS":"KGS","KHR":"KHR","KMF":"KMF","KPW":"KPW","KRW":"KRW","KWD":"KWD","KYD":"KYD","KZT":"KZT","LAK":"LAK","LBP":"LBP","LKR":"LKR","LRD":"LRD","LSL":"LSL","LTL":"LTL","LVL":"LVL","LYD":"LYD","MAD":"MAD","MDL":"MDL","MGA":"MGA","MKD":"MKD","MMK":"MMK","MNT":"MNT","MOP":"MOP","MRO":"MRO","MTL":"MTL","MUR":"MUR","MVR":"MVR","MWK":"MWK","MXN":"MXN","MYR":"MYR","MZM":"MZM","NAD":"NAD","NGN":"NGN","NIO":"NIO","NOK":"NOK","NPR":"NPR","NZD":"NZD","OMR":"OMR","PAB":"PAB","PEN":"PEN","PGK":"PGK","PHP":"PHP","PKR":"PKR","PLN":"PLN","PTS":"PTS","PYG":"PYG","QAR":"QAR","RON":"RON","RUB":"RUB","RWF":"RWF","SAR":"SAR","SBD":"SBD","SCR":"SCR","SDD":"SDD","SEK":"SEK","SGD":"SGD","SHP":"SHP","SIT":"SIT","SKK":"SKK","SLL":"SLL","SOS":"SOS","SPL":"SPL","SRD":"SRD","STD":"STD","SVC":"SVC","SYP":"SYP","SZL":"SZL","THB":"THB","TJS":"TJS","TMM":"TMM","TND":"TND","TOP":"TOP","TRL":"TRL","TRY":"TRY","TTD":"TTD","TVD":"TVD","TWD":"TWD","TZS":"TZS","UAH":"UAH","UGX":"UGX","USD":"USD","UYU":"UYU","UZS":"UZS","VEF":"VEF","VND":"VND","VUV":"VUV","WST":"WST","XAF":"XAF","XAG":"XAG","XAU":"XAU","XCD":"XCD","XDR":"XDR","XOF":"XOF","XPD":"XPD","XPF":"XPF","XPT":"XPT","YER":"YER","ZAR":"ZAR","ZMK":"ZMK","ZWD":"ZWD"}}','extra_parameters' => NULL,'supported_currency' => '["CAD"]','receivable_currencies' => '[{"name":"CAD","currency_symbol":"CAD","conversion_rate":"0.04","min_limit":"1","max_limit":"10000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '27','code' => 'nowpayments','name' => 'Nowpayments','sort_by' => '24','image' => 'gateway/OzQTxAEDR7XztVJGQWR6Itpf0KzEI5QA4dJn8Z3C.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":""}','currencies' => '{"1":{"BTG":"BTG","ETH":"ETH","XMR":"XMR","ZEC":"ZEC","XVG":"XVG","ADA":"ADA","LTC":"LTC","BCH":"BCH","QTUM":"QTUM","DASH":"DASH","XLM":"XLM","XRP":"XRP","XEM":"XEM","DGB":"DGB","LSK":"LSK","DOGE":"DOGE","TRX":"TRX","KMD":"KMD","REP":"REP","BAT":"BAT","ARK":"ARK","WAVES":"WAVES","BNB":"BNB","XZC":"XZC","NANO":"NANO","TUSD":"TUSD","VET":"VET","ZEN":"ZEN","GRS":"GRS","FUN":"FUN","NEO":"NEO","GAS":"GAS","PAX":"PAX","USDC":"USDC","ONT":"ONT","XTZ":"XTZ","LINK":"LINK","RVN":"RVN","BNBMAINNET":"BNBMAINNET","ZIL":"ZIL","BCD":"BCD","USDT":"USDT","USDTERC20":"USDTERC20","CRO":"CRO","DAI":"DAI","HT":"HT","WABI":"WABI","BUSD":"BUSD","ALGO":"ALGO","USDTTRC20":"USDTTRC20","GT":"GT","STPT":"STPT","AVA":"AVA","SXP":"SXP","UNI":"UNI","OKB":"OKB","BTC":"BTC"}}','extra_parameters' => '{"cron":"ipn"}','supported_currency' => '["BTG"]','receivable_currencies' => '[{"name":"BTG","currency_symbol":"BTG","conversion_rate":"0.0","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '28','code' => 'khalti','name' => 'Khalti Payment','sort_by' => '31','image' => 'gateway/5FlBlZbZQaLr8KwuD2Z3HcXF5KRSFlsOrrao1mkh.webp','driver' => 'local','status' => '0','parameters' => '{"secret_key":"","public_key":""}','currencies' => '{"0":{"NPR":"NPR"}}','extra_parameters' => NULL,'supported_currency' => '["NPR"]','receivable_currencies' => '[{"name":"NPR","currency_symbol":"NPR","conversion_rate":"3.2","min_limit":"1","max_limit":"10000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '29','code' => 'swagger','name' => 'MAGUA PAY','sort_by' => '28','image' => 'gateway/tD4p45Gtq8IeH6VE8xNUIAWvqhURHd11GyFsktnT.png','driver' => 'local','status' => '0','parameters' => '{"MAGUA_PAY_ACCOUNT":"","MerchantKey":"","Secret":""}','currencies' => '{"0":{"EUR":"EUR"}}','extra_parameters' => NULL,'supported_currency' => '["EUR"]','receivable_currencies' => '[{"name":"EUR","currency_symbol":"EUR","conversion_rate":"0.012","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '30','code' => 'freekassa','name' => 'Free kassa','sort_by' => '36','image' => 'gateway/FZFq5hvlmxrGPvMnNwyg8yUdFEndyF8DScXzYfBt.jpg','driver' => 'local','status' => '0','parameters' => '{"merchant_id":"","merchant_key":"","secret_word":"","secret_word2":""}','currencies' => '{"0":{"RUB":"RUB","USD":"USD","EUR":"EUR","UAH":"UAH","KZT":"KZT"}}','extra_parameters' => '{"ipn_url":"ipn"}','supported_currency' => '["RUB"]','receivable_currencies' => '[{"name":"RUB","currency_symbol":"RUB","conversion_rate":"1.5","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '31','code' => 'konnect','name' => 'Konnect','sort_by' => '26','image' => 'gateway/z6zovJ6lY6kC4zdYnRoq1bBnA6ZaTPOx5iSIbMtU.jpg','driver' => 'local','status' => '0','parameters' => '{"api_key":"","receiver_wallet_Id":""}','currencies' => '{"0":{"TND":"TND","EUR":"EUR","USD":"USD"}}','extra_parameters' => '{"webhook":"ipn"}','supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.091","min_limit":"1","max_limit":"100000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '32','code' => 'mypay','name' => 'Mypay Np','sort_by' => '32','image' => 'gateway/5toHnr3MrwpZxIYNzYUyW0D4hpQHdR82VflDN6E3.png','driver' => 'local','status' => '0','parameters' => '{"merchant_username":"","merchant_api_password":"","merchant_id":"","api_key":""}','currencies' => '{"0":{"NPR":"NPR"}}','extra_parameters' => NULL,'supported_currency' => '["NPR"]','receivable_currencies' => '[{"name":"NPR","currency_symbol":"NPR","conversion_rate":"3.2","min_limit":"1","max_limit":"100000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '33','code' => 'imepay','name' => 'IME PAY','sort_by' => '9','image' => 'gateway/9yQ74D7KxvzB9hFrcu3ZQJsBFEq33AMIa7FDakIc.png','driver' => 'local','status' => '0','parameters' => '{"MerchantModule":"","MerchantCode":"","username":"","password":""}','currencies' => '{"0":{"NPR":"NPR"}}','extra_parameters' => NULL,'supported_currency' => '["NPR"]','receivable_currencies' => '[{"name":"NPR","currency_symbol":"NPR","conversion_rate":"1.21","min_limit":"1","max_limit":"100000","percentage_charge":"0.0","fixed_charge":"1.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => '','is_subscription' => '0','subscription_on' => '0','created_at' => '2020-09-09 09:05:02','updated_at' => '2024-02-25 18:12:01'),
            array('id' => '34','code' => 'cashonexHosted','name' => 'Cashonex Hosted','sort_by' => '14','image' => 'gateway/2wj8WTytWbD4TIaeJWUZ3YsWh3uHdH7KoxhgzZSO.png','driver' => 'local','status' => '0','parameters' => '{"idempotency_key":"","salt":""}','currencies' => '{"0":{"USD":"USD"}}','extra_parameters' => NULL,'supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.0091","min_limit":"1","max_limit":"50000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2023-04-03 06:31:33','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '35','code' => 'cashonex','name' => 'cashonex','sort_by' => '17','image' => 'gateway/FLh4uLhShoYSbbUAPy5PASJ88g1xZACLyeM2hEWU.jpg','driver' => 'local','status' => '0','parameters' => '{"idempotency_key":"","salt":""}','currencies' => '{"0":{"USD":"USD"}}','extra_parameters' => NULL,'supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"0.0091","min_limit":"1","max_limit":"1000000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2023-04-03 06:34:54','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '36','code' => 'binance','name' => 'Binance','sort_by' => '12','image' => 'gateway/YbukIVm9M9IDWcRcS6j26FbYI8qAEQsE1N0zGIL0.png','driver' => 'local','status' => '0','parameters' => '{"mercent_api_key":"","mercent_secret":""}','currencies' => '{"1":{"ADA":"ADA","ATOM":"ATOM","AVA":"AVA","BCH":"BCH","BNB":"BNB","BTC":"BTC","BUSD":"BUSD","CTSI":"CTSI","DASH":"DASH","DOGE":"DOGE","DOT":"DOT","EGLD":"EGLD","EOS":"EOS","ETC":"ETC","ETH":"ETH","FIL":"FIL","FRONT":"FRONT","FTM":"FTM","GRS":"GRS","HBAR":"HBAR","IOTX":"IOTX","LINK":"LINK","LTC":"LTC","MANA":"MANA","MATIC":"MATIC","NEO":"NEO","OM":"OM","ONE":"ONE","PAX":"PAX","QTUM":"QTUM","STRAX":"STRAX","SXP":"SXP","TRX":"TRX","TUSD":"TUSD","UNI":"UNI","USDC":"USDC","USDT":"USDT","WRX":"WRX","XLM":"XLM","XMR":"XMR","XRP":"XRP","XTZ":"XTZ","XVS":"XVS","ZEC":"ZEC","ZIL":"ZIL"}}','extra_parameters' => NULL,'supported_currency' => '["ADA"]','receivable_currencies' => '[{"name":"ADA","currency_symbol":"ADA","conversion_rate":"0.037","min_limit":"1","max_limit":"1000","percentage_charge":"0.0","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => '','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2023-04-03 07:36:14','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '37','code' => 'cinetpay','name' => 'CinetPay','sort_by' => '37','image' => 'gateway/CRzsgpZMlq19bQwfTukPoWuhZHbDgwx08bl7g9Ll.jpg','driver' => 'local','status' => '0','parameters' => '{"apiKey":"","site_id":""}','currencies' => '{"0":{"XOF":"XOF","XAF":"XAF","CDF":"CDF","GNF":"GNF","USD":"USD"}}','extra_parameters' => 'NULL','supported_currency' => '["XOF"]','receivable_currencies' => '[{"name":"XOF","currency_symbol":"XOF","conversion_rate":"0.12","min_limit":"1","max_limit":"1000000","percentage_charge":"1.5","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '0','subscription_on' => '0','created_at' => '2023-04-03 07:36:14','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '38','code' => 'square','name' => 'Square','sort_by' => '38','image' => 'gateway/tgnUjnfjA20JYs8kNffP2YDSw7LVoI.avif','driver' => 'local','status' => '0','parameters' => '{"application_id":"","access_token":"","location_id":""}','currencies' => '{"0":{
  "USD": "USD",
  "AED": "AED",
  "AFN": "AFN",
  "ALL": "ALL",
  "AMD": "AMD",
  "ANG": "ANG",
  "AOA": "AOA",
  "ARS": "ARS",
  "AUD": "AUD",
  "AWG": "AWG",
  "AZN": "AZN",
  "BAM": "BAM",
  "BBD": "BBD",
  "BDT": "BDT",
  "BGN": "BGN",
  "BHD": "BHD",
  "BIF": "BIF",
  "BMD": "BMD",
  "BND": "BND",
  "BOB": "BOB",
  "BOV": "BOV",
  "BRL": "BRL",
  "BSD": "BSD",
  "BTN": "BTN",
  "BWP": "BWP",
  "BYR": "BYR",
  "BZD": "BZD",
  "CAD": "CAD",
  "CDF": "CDF",
  "CHE": "CHE",
  "CHF": "CHF",
  "CHW": "CHW",
  "CLF": "CLF",
  "CLP": "CLP",
  "CNY": "CNY",
  "COP": "COP",
  "COU": "COU",
  "CRC": "CRC",
  "CUC": "CUC",
  "CUP": "CUP",
  "CVE": "CVE",
  "CZK": "CZK",
  "DJF": "DJF",
  "DKK": "DKK",
  "DOP": "DOP",
  "DZD": "DZD",
  "EGP": "EGP",
  "ERN": "ERN",
  "ETB": "ETB",
  "EUR": "EUR",
  "FJD": "FJD",
  "FKP": "FKP",
  "GBP": "GBP",
  "GEL": "GEL",
  "GHS": "GHS",
  "GIP": "GIP",
  "GMD": "GMD",
  "GNF": "GNF",
  "GTQ": "GTQ",
  "GYD": "GYD",
  "HKD": "HKD",
  "HNL": "HNL",
  "HRK": "HRK",
  "HTG": "HTG",
  "HUF": "HUF",
  "IDR": "IDR",
  "ILS": "ILS",
  "INR": "INR",
  "IQD": "IQD",
  "IRR": "IRR",
  "ISK": "ISK",
  "JMD": "JMD",
  "JOD": "JOD",
  "JPY": "JPY",
  "KES": "KES",
  "KGS": "KGS",
  "KHR": "KHR",
  "KMF": "KMF",
  "KPW": "KPW",
  "KRW": "KRW",
  "KWD": "KWD",
  "KYD": "KYD",
  "KZT": "KZT",
  "LAK": "LAK",
  "LBP": "LBP",
  "LKR": "LKR",
  "LRD": "LRD",
  "LSL": "LSL",
  "LTL": "LTL",
  "LVL": "LVL",
  "LYD": "LYD",
  "MAD": "MAD",
  "MDL": "MDL",
  "MGA": "MGA",
  "MKD": "MKD",
  "MMK": "MMK",
  "MNT": "MNT",
  "MOP": "MOP",
  "MRO": "MRO",
  "MUR": "MUR",
  "MVR": "MVR",
  "MWK": "MWK",
  "MXN": "MXN",
  "MXV": "MXV",
  "MYR": "MYR",
  "MZN": "MZN",
  "NAD": "NAD",
  "NGN": "NGN",
  "NIO": "NIO",
  "NOK": "NOK",
  "NPR": "NPR",
  "NZD": "NZD",
  "OMR": "OMR",
  "PAB": "PAB",
  "PEN": "PEN",
  "PGK": "PGK",
  "PHP": "PHP",
  "PKR": "PKR",
  "PLN": "PLN",
  "PYG": "PYG",
  "QAR": "QAR",
  "RON": "RON",
  "RSD": "RSD",
  "RUB": "RUB",
  "RWF": "RWF",
  "SAR": "SAR",
  "SBD": "SBD",
  "SCR": "SCR",
  "SDG": "SDG",
  "SEK": "SEK",
  "SGD": "SGD",
  "SHP": "SHP",
  "SLL": "SLL",
  "SOS": "SOS",
  "SRD": "SRD",
  "SSP": "SSP",
  "STD": "STD",
  "SVC": "SVC",
  "SYP": "SYP",
  "SZL": "SZL",
  "THB": "THB",
  "TJS": "TJS",
  "TMT": "TMT",
  "TND": "TND",
  "TOP": "TOP",
  "TRY": "TRY",
  "TTD": "TTD",
  "TWD": "TWD",
  "TZS": "TZS",
  "UAH": "UAH",
  "UGX": "UGX",
  "USN": "USN",
  "USS": "USS",
  "UYI": "UYI",
  "UYU": "UYU",
  "UZS": "UZS",
  "VEF": "VEF",
  "VND": "VND",
  "VUV": "VUV",
  "WST": "WST",
  "XAF": "XAF",
  "XAG": "XAG",
  "XAU": "XAU",
  "XBA": "XBA",
  "XBB": "XBB",
  "XBC": "XBC",
  "XBD": "XBD",
  "XCD": "XCD",
  "XDR": "XDR",
  "XOF": "XOF",
  "XPD": "XPD",
  "XPF": "XPF",
  "XPT": "XPT"}}','extra_parameters' => '{"payment_webhook_url":"ipn","subscription_webhook_url":"subscription.ipn"}','supported_currency' => '["USD"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"1","min_limit":"1","max_limit":"10000","percentage_charge":"0.5","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => NULL,'is_subscription' => '1','subscription_on' => '0','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '39','code' => 'paddle','name' => 'Paddle','sort_by' => '39','image' => 'gateway/ctJGPni1AMRJAU5xNCDJVUbP5MgD8t.webp','driver' => 'local','status' => '1','parameters' => '{"api_key":"54f6d9bf5dfb2564749c382765eadb11b202f14df41c3103e3","client_side_token":"test_a77e7f137646998a8483488584e"}','currencies' => '{"0":{
  "USD": "USD",
  "EUR": "EUR",
  "GBP": "GBP",
  "ARS": "ARS",
  "AUD": "AUD",
  "BRL": "BRL",
  "CAD": "CAD",
  "CNY": "CNY",
  "COP": "COP",
  "CZK": "CZK",
  "DKK": "DKK",
  "HKD": "HKD",
  "HUF": "HUF",
  "ILS": "ILS",
  "INR": "INR",
  "JPY": "JPY",
  "KRW": "KRW",
  "MXN": "MXN",
  "NOK": "NOK",
  "NZD": "NZD",
  "DKK": "DKK",
  "PLN": "PLN",
  "RUB": "RUB",
  "SEK": "SEK",
  "SGD": "SGD",
  "THB": "THB",
  "TRY": "TRY",
  "TWD": "TWD",
  "UAH": "UAH",
  "ZAR": "ZAR"}}','extra_parameters' => '{"default_payment_link":"ipn","subscription_webhook_url":"subscription.ipn"}','supported_currency' => '["USD","GBP"]','receivable_currencies' => '[{"name":"USD","currency_symbol":"USD","conversion_rate":"1","min_limit":"1","max_limit":"10000","percentage_charge":"0.5","fixed_charge":"0.5"},{"name":"GBP","currency_symbol":"GBP","conversion_rate":"0.90","min_limit":"1","max_limit":"100","percentage_charge":"1","fixed_charge":"1"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '1','environment' => 'test','is_manual' => NULL,'note' => 'Paddle exclusively offers subscription-based support, with no provision for one-time payments in this regard.','is_subscription' => '1','subscription_on' => '1','created_at' => '2020-09-10 15:05:02','updated_at' => '2024-02-25 18:12:02'),
            array('id' => '1000','code' => 'bank-transfer','name' => 'Bank Transfer','sort_by' => '1','image' => 'gateway/ewUeajVsIo2wwAdnDCIrbqFwqcLMjxamfCU6Xl3B.jpg','driver' => 'local','status' => '1','parameters' => '{"AccountNumber":{"field_name":"AccountNumber","field_label":"Account Number","type":"text","validation":"required"},"BeneficiaryName":{"field_name":"BeneficiaryName","field_label":"Beneficiary Name","type":"text","validation":"required"},"NID":{"field_name":"NID","field_label":"NID","type":"file","validation":"required"},"Address":{"field_name":"Address","field_label":"Address","type":"text","validation":"required"}}','currencies' => NULL,'extra_parameters' => NULL,'supported_currency' => '["USD","EUR"]','receivable_currencies' => '[{"currency":"USD","conversion_rate":"1","min_limit":"1","max_limit":"1000","percentage_charge":"0.5","fixed_charge":"0.5"},{"currency":"EUR","conversion_rate":"2","min_limit":"1","max_limit":"1000","percentage_charge":"0.5","fixed_charge":"0.5"}]','description' => 'Send form your payment gateway. your bank may charge you a cash advance fee.','currency_type' => '1','is_sandbox' => '0','environment' => 'live','is_manual' => NULL,'note' => 'Send form your payment gateway. your bank may charge you a cash advance fee.Send form your payment gateway. your bank may charge you a cash advance fee.Send form your payment gateway. your bank may charge you a cash advance fee.Send form your payment gateway. your bank may charge you a cash advance fee.Send form your payment gateway. your bank may charge you a cash advance fee.','is_subscription' => '0','subscription_on' => '0','created_at' => NULL,'updated_at' => '2023-12-24 11:41:05')
        );

        DB::table('gateways')->insert($gateways);
    }
}
