<!-- Navbar Vertical -->
<aside
    class="js-navbar-vertical-aside navbar navbar-vertical-aside navbar-vertical navbar-vertical-fixed navbar-expand-xl navbar-vertical-aside-initialized
    <?php echo e(in_array(session()->get('themeMode'), [null, 'auto'] )?  'navbar-dark bg-dark ' : 'navbar-light bg-white'); ?>">
    <div class="navbar-vertical-container">
        <div class="navbar-vertical-footer-offset">
            <!-- Logo -->
            <a class="navbar-brand" href="<?php echo e(route('admin.dashboard')); ?>" aria-label="<?php echo e($basicControl->site_title); ?>">
                <img class="navbar-brand-logo navbar-brand-logo-auto"
                     src="<?php echo e(getFile(session()->get('themeMode') == 'auto'?$basicControl->admin_dark_mode_logo_driver : $basicControl->admin_logo_driver, session()->get('themeMode') == 'auto'?$basicControl->admin_dark_mode_logo:$basicControl->admin_logo, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="default">

                <img class="navbar-brand-logo"
                     src="<?php echo e(getFile($basicControl->admin_dark_mode_logo_driver, $basicControl->admin_dark_mode_logo, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="dark">

                <img class="navbar-brand-logo-mini"
                     src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                     alt="<?php echo e($basicControl->site_title); ?> Logo"
                     data-hs-theme-appearance="default">
                <img class="navbar-brand-logo-mini"
                     src="<?php echo e(getFile($basicControl->favicon_driver, $basicControl->favicon, true)); ?>"
                     alt="Logo"
                     data-hs-theme-appearance="dark">
            </a>
            <!-- End Logo -->

            <!-- Navbar Vertical Toggle -->
            <button type="button" class="js-navbar-vertical-aside-toggle-invoker navbar-aside-toggler">
                <i class="bi-arrow-bar-left navbar-toggler-short-align"
                   data-bs-template='<div class="tooltip d-none d-md-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                   data-bs-toggle="tooltip"
                   data-bs-placement="right"
                   title="Collapse">
                </i>
                <i
                    class="bi-arrow-bar-right navbar-toggler-full-align"
                    data-bs-template='<div class="tooltip d-none d-md-block" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                    data-bs-toggle="tooltip"
                    data-bs-placement="right"
                    title="Expand"
                ></i>
            </button>
            <!-- End Navbar Vertical Toggle -->

            <!-- Content -->
            <div class="navbar-vertical-content">
                <div id="navbarVerticalMenu" class="nav nav-pills nav-vertical card-navbar-nav">

                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.dashboard'])); ?>"
                           href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="bi-house-door nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("Dashboard"); ?></span>
                        </a>
                    </div>

                    <?php if(adminAccessRoute('Manage Staff')): ?>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.role.staff'])); ?>"
                               href="<?php echo e(route('admin.role.staff')); ?>">
                                <i class="fa-light fa-user nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Manage Staff"); ?></span>
                            </a>
                        </div>

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.role'])); ?>"
                               href="<?php echo e(route('admin.role')); ?>" data-placement="left">
                                <i class="fa-light fa-users-gear nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Role & Permission'); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>


                    <?php if(adminAccessRoute('Card')): ?>
                        <span class="dropdown-header mt-2"><?php echo app('translator')->get('Cards'); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(request()->query('type') == 'card'? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.categoryList').'?type=card'); ?>" data-placement="left">
                                <i class="fas fa-tags nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Category"); ?></span>
                            </a>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.card.list','admin.card.store','admin.card.edit',
                           'admin.cardService.list','admin.cardServiceCode.list'])); ?>"
                               href="<?php echo e(route('admin.card.list')); ?>" data-placement="left">
                                <i class="fas fa-vr-cardboard nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Card"); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if(adminAccessRoute('Direct Top Up')): ?>
                        <span class="dropdown-header mt-2"><?php echo app('translator')->get('Direct Top Up'); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(request()->query('type') == 'top_up'? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.categoryList').'?type=top_up'); ?>" data-placement="left">
                                <i class="fas fa-tags nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Category"); ?></span>
                            </a>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.topUpList','admin.topUpStore','admin.topUpEdit','admin.topUpService.list'])); ?>"
                               href="<?php echo e(route('admin.topUpList')); ?>" data-placement="left">
                                <i class="fas fa-shield-alt nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Top Up"); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if(adminAccessRoute('All Orders')): ?>
                        <span class="dropdown-header mt-2"> <?php echo app('translator')->get("Orders"); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.orderTopUp.list','admin.orderTopUp.view'], 3)); ?>"
                               href="#navbarVerticalOrderMenu"
                               role="button"
                               data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalOrderMenu"
                               aria-expanded="false"
                               aria-controls="navbarVerticalOrderMenu">
                                <i class="fa-light fas fa-shield-alt nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Top Up Order"); ?></span>
                            </a>
                            <div id="navbarVerticalOrderMenu"
                                 class="nav-collapse collapse <?php echo e(menuActive(['admin.orderTopUp.list','admin.orderTopUp.view'], 2)); ?>"
                                 data-bs-parent="#navbarVerticalOrderMenu">
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderTopUp.list') && @request()->type == 'all') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderTopUp.list').'?type=all'); ?>"><?php echo app('translator')->get("All Orders"); ?>
                                </a>
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderTopUp.list') && @request()->type == 'pending') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderTopUp.list').'?type=pending'); ?>"><?php echo app('translator')->get("Pending Orders"); ?></a>
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderTopUp.list') && @request()->type == 'complete') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderTopUp.list').'?type=complete'); ?>"><?php echo app('translator')->get("Complete Orders"); ?></a>
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderTopUp.list') && @request()->type == 'refund') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderTopUp.list').'?type=refund'); ?>"><?php echo app('translator')->get("Refund Orders"); ?></a>
                            </div>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.orderCard.list','admin.orderCard.view'], 3)); ?>"
                               href="#navbarVerticalCardOrderMenu"
                               role="button"
                               data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalCardOrderMenu"
                               aria-expanded="false"
                               aria-controls="navbarVerticalCardOrderMenu">
                                <i class="fa-light fas fa-vr-cardboard nav-icon nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Card Order"); ?></span>
                            </a>
                            <div id="navbarVerticalCardOrderMenu"
                                 class="nav-collapse collapse <?php echo e(menuActive(['admin.orderCard.list','admin.orderCard.view'], 2)); ?>"
                                 data-bs-parent="#navbarVerticalCardOrderMenu">
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderCard.list') && @request()->type == 'all') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderCard.list').'?type=all'); ?>"><?php echo app('translator')->get("All Orders"); ?>
                                </a>
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderCard.list') && @request()->type == 'pending') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderCard.list').'?type=pending'); ?>"><?php echo app('translator')->get("Pending Orders"); ?></a>
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderCard.list') && @request()->type == 'complete') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderCard.list').'?type=complete'); ?>"><?php echo app('translator')->get("Complete Orders"); ?></a>
                                <a class="nav-link <?php echo e((request()->routeIs('admin.orderCard.list') && @request()->type == 'refund') ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.orderCard.list').'?type=refund'); ?>"><?php echo app('translator')->get("Refund Orders"); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!--
                    <?php if($basicControl->sell_post == 1): ?>
                        <span class="dropdown-header mt-2"> <?php echo app('translator')->get("Sell Post"); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.sellPostCategory*'])); ?>"
                               href="<?php echo e(route('admin.sellPostCategory')); ?>" data-placement="left">
                                <i class="fa-light fa-bullhorn nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Sell Category"); ?></span>
                            </a>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.gameSellList','admin.sell.details','admin.sellPost.conversation'], 3)); ?>"
                               href="#navbarVerticalSellPostMenu"
                               role="button"
                               data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalSellPostMenu"
                               aria-expanded="false"
                               aria-controls="navbarVerticalSellPostMenu">
                                <i class="bi bi-graph-up-arrow nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Selling Post"); ?></span>
                            </a>
                            <div id="navbarVerticalSellPostMenu"
                                 class="nav-collapse collapse <?php echo e(menuActive(['admin.gameSellList','admin.sell.details','admin.sellPost.conversation'], 2)); ?>"
                                 data-bs-parent="#navbarVerticalSellPostMenu">
                                <a class="nav-link <?php echo e(last(request()->segments()) == 'approval' ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.gameSellList','approval')); ?>"><?php echo app('translator')->get("Approval"); ?></a>

                                <a class="nav-link <?php echo e(last(request()->segments()) == 'pending' ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.gameSellList','pending')); ?>"><?php echo app('translator')->get("Pending"); ?></a>

                                <a class="nav-link <?php echo e(last(request()->segments()) == 'resubmission' ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.gameSellList','resubmission')); ?>"><?php echo app('translator')->get("Resubmission"); ?></a>

                                <a class="nav-link <?php echo e(last(request()->segments()) == 'hold' ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.gameSellList','hold')); ?>"><?php echo app('translator')->get("Hold"); ?></a>

                                <a class="nav-link <?php echo e(last(request()->segments()) == 'soft-reject' ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.gameSellList','soft-reject')); ?>"><?php echo app('translator')->get("Soft Rejected"); ?></a>

                                <a class="nav-link <?php echo e(last(request()->segments()) == 'hard-reject' ? 'active':''); ?>"
                                   href="<?php echo e(route('admin.gameSellList','hard-reject')); ?>"><?php echo app('translator')->get("Hard Rejected"); ?></a>

                            </div>
                        </div>

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.postSell*'])); ?>"
                               href="<?php echo e(route('admin.postSell')); ?>" data-placement="left">
                                <i class="fa-light fa-newspaper nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Sold Post"); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>
                    -->

                    <?php if(adminAccessRoute('All Transactions')): ?>
                        <span class="dropdown-header mt-2"><?php echo app('translator')->get('Transactions'); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.transaction'])); ?>"
                               href="<?php echo e(route('admin.transaction')); ?>" data-placement="left">
                                <i class="bi bi-send nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Transaction"); ?></span>
                            </a>
                        </div>
                        <!-- Remove or comment out the Withdraw Log section -->
                        <!--
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.payout.log'])); ?>"
                               href="<?php echo e(route('admin.payout.log')); ?>" data-placement="left">
                                <i class="bi bi-wallet2 nav-icon "></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Withdraw Log"); ?></span>
                            </a>
                        </div>
                        -->

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.payment.log'])); ?>"
                               href="<?php echo e(route('admin.payment.log')); ?>" data-placement="left">
                                <i class="bi bi-credit-card-2-front nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Payment Log"); ?></span>
                            </a>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.payment.pending'])); ?>"
                               href="<?php echo e(route('admin.payment.pending')); ?>" data-placement="left">
                                <i class="bi bi-cash nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Payment Request"); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if(adminAccessRoute('All Marketing')): ?>
                        <span class="dropdown-header mt-2"><?php echo app('translator')->get('Marketing'); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.campaign.view'])); ?>"
                               href="<?php echo e(route('admin.campaign.view')); ?>" data-placement="left">
                                <i class="fa-light fa-bullhorn nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Campaign"); ?></span>
                            </a>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.couponList','admin.couponStore','admin.couponEdit'])); ?>"
                               href="<?php echo e(route('admin.couponList')); ?>" data-placement="left">
                                <i class="fa-light fa-percent nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Coupon"); ?></span>
                            </a>
                        </div>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.review.list'])); ?>"
                               href="<?php echo e(route('admin.review.list')); ?>" data-placement="left">
                                <i class="bi bi-emoji-smile nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Review"); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>


                    <?php if(adminAccessRoute('Support Ticket')): ?>
                        <span class="dropdown-header mt-2"> <?php echo app('translator')->get("Ticket Panel"); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.ticket', 'admin.ticket.search', 'admin.ticket.view'], 3)); ?>"
                               href="#navbarVerticalTicketMenu"
                               role="button"
                               data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalTicketMenu"
                               aria-expanded="false"
                               aria-controls="navbarVerticalTicketMenu">
                                <i class="fa-light fa-headset nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get("Support Ticket"); ?></span>
                            </a>
                            <div id="navbarVerticalTicketMenu"
                                 class="nav-collapse collapse <?php echo e(menuActive(['admin.ticket','admin.ticket.search', 'admin.ticket.view'], 2)); ?>"
                                 data-bs-parent="#navbarVerticalTicketMenu">
                                <a class="nav-link <?php echo e(request()->is('admin/tickets/all') ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.ticket', 'all')); ?>"><?php echo app('translator')->get("All Tickets"); ?>
                                </a>
                                <a class="nav-link <?php echo e(request()->is('admin/tickets/answered') ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.ticket', 'answered')); ?>"><?php echo app('translator')->get("Answered Ticket"); ?></a>
                                <a class="nav-link <?php echo e(request()->is('admin/tickets/replied') ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.ticket', 'replied')); ?>"><?php echo app('translator')->get("Replied Ticket"); ?></a>
                                <a class="nav-link <?php echo e(request()->is('admin/tickets/closed') ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.ticket', 'closed')); ?>"><?php echo app('translator')->get("Closed Ticket"); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <span class="dropdown-header mt-2"> <?php echo app('translator')->get('Kyc Management'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['admin.kyc.form.list','admin.kyc.edit','admin.kyc.create'])); ?>"
                           href="<?php echo e(route('admin.kyc.form.list')); ?>" data-placement="left">
                            <i class="bi-stickies nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('KYC Setting'); ?></span>
                        </a>
                    </div>

                    <div class="nav-item" <?php echo e(menuActive(['admin.kyc.list*','admin.kyc.view'], 3)); ?>>
                        <a class="nav-link dropdown-toggle collapsed" href="#navbarVerticalKycRequestMenu"
                           role="button"
                           data-bs-toggle="collapse" data-bs-target="#navbarVerticalKycRequestMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalKycRequestMenu">
                            <i class="bi bi-person-lines-fill nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get("KYC Request"); ?></span>
                        </a>
                        <div id="navbarVerticalKycRequestMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.kyc.list*','admin.kyc.view'], 2)); ?>"
                             data-bs-parent="#navbarVerticalKycRequestMenu">

                            <a class="nav-link <?php echo e(Request::is('admin/kyc/pending') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'pending')); ?>">
                                <?php echo app('translator')->get('Pending KYC'); ?>
                            </a>
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/approve') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'approve')); ?>">
                                <?php echo app('translator')->get('Approved KYC'); ?>
                            </a>
                            <a class="nav-link <?php echo e(Request::is('admin/kyc/rejected') ? 'active' : ''); ?>"
                               href="<?php echo e(route('admin.kyc.list', 'rejected')); ?>">
                                <?php echo app('translator')->get('Rejected KYC'); ?>
                            </a>
                        </div>
                    </div>

                    <?php if(adminAccessRoute('User Management')): ?>
                        <span class="dropdown-header mt-2"> <?php echo app('translator')->get("User Panel"); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>

                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.users'], 3)); ?>"
                               href="#navbarVerticalUserPanelMenu"
                               role="button"
                               data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalUserPanelMenu"
                               aria-expanded="false"
                               aria-controls="navbarVerticalUserPanelMenu">
                                <i class="bi-people nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('User Management'); ?></span>
                            </a>
                            <div id="navbarVerticalUserPanelMenu"
                                 class="nav-collapse collapse <?php echo e(menuActive(['admin.mail.all.user','admin.users','admin.users.add','admin.user.edit',
                                                                        'admin.user.view.profile','admin.user.transaction','admin.user.payment',
                                                                        'admin.user.payout','admin.user.kyc.list','admin.send.email'], 2)); ?>"
                                 data-bs-parent="#navbarVerticalUserPanelMenu">

                                <a class="nav-link d-flex justify-content-between
                             <?php echo e(request('status') === 'activeUser' ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.users', ['status' => 'activeUser'])); ?>">
                                    <span class="nav-link-title"><?php echo app('translator')->get('Active User'); ?></span>
                                </a>
                                <a class="nav-link d-flex justify-content-between <?php echo e(request('status') === 'blocked' ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.users', ['status' => 'blocked'])); ?>">
                                    <span class="nav-link-title"><?php echo app('translator')->get('Banned User'); ?></span> <span
                                        class="badge bg-primary rounded-pill ms-1 bannedUser"></span>
                                </a>
                                <a class="nav-link d-flex justify-content-between <?php echo e(request('status') === 'emailUnVerify' ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.users',['status' => 'emailUnVerify'])); ?>">
                                    <span class="nav-link-title"><?php echo app('translator')->get('Email Unverified'); ?></span> <span
                                        class="badge bg-primary rounded-pill ms-1 emailUnverified"></span>
                                </a>
                                <a class="nav-link d-flex justify-content-between <?php echo e(request('status') === 'smsUnVerify' ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.users' ,['status' => 'smsUnVerify'])); ?>">
                                    <span class="nav-link-title"><?php echo app('translator')->get('Sms Unverified'); ?></span> <span
                                        class="badge bg-primary rounded-pill ms-1 smsUnverified"></span>
                                </a>
                                <a class="nav-link d-flex justify-content-between <?php echo e(request('status') === 'withBlalnce' ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.users', ['status' => 'withBlalnce'])); ?>">
                                    <span class="nav-link-title"><?php echo app('translator')->get('With Balance'); ?></span>
                                </a>

                                <a class="nav-link d-flex justify-content-between <?php echo e(request('status') === 'all' ? 'active' : ''); ?>"
                                   href="<?php echo e(route('admin.users', ['status' => 'all'])); ?>">
                                    <span class="nav-link-title"><?php echo app('translator')->get('All User'); ?></span>
                                </a>

                                <a class="nav-link <?php echo e(menuActive(['admin.mail.all.user'])); ?>"
                                   href="<?php echo e(route("admin.mail.all.user")); ?>"><?php echo app('translator')->get('Mail To Users'); ?></a>
                            </div>
                        </div>

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.userActivity'])); ?>"
                               href="<?php echo e(route('admin.userActivity')); ?>" data-placement="left">
                                <i class="fal fa-waveform nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('User Activity'); ?></span>
                            </a>
                        </div>

                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.subscribe'])); ?>"
                               href="<?php echo e(route('admin.subscribe')); ?>" data-placement="left">
                                <i class="fas fa-users nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Subscribers'); ?></span>
                            </a>
                        </div>
                    <?php endif; ?>

                    <?php if(adminAccessRoute('Control Panel') || adminAccessRoute('Payment Methods')): ?>
                        <span class="dropdown-header mt-2"> <?php echo app('translator')->get('SETTINGS PANEL'); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>

                        <?php if(adminAccessRoute('Control Panel')): ?>
                            <div class="nav-item">
                                <a class="nav-link <?php echo e(menuActive(controlPanelRoutes())); ?>"
                                   href="<?php echo e(route('admin.settings')); ?>" data-placement="left">
                                    <i class="bi bi-gear nav-icon"></i>
                                    <span class="nav-link-title"><?php echo app('translator')->get('Control Panel'); ?></span>
                                </a>
                            </div>
                        <?php endif; ?>

                        <?php if(adminAccessRoute('Payment Methods')): ?>
                            <div
                                class="nav-item <?php echo e(menuActive(['admin.payment.methods', 'admin.edit.payment.methods', 'admin.deposit.manual.index', 'admin.deposit.manual.create', 'admin.deposit.manual.edit'], 3)); ?>">
                                <a class="nav-link dropdown-toggle"
                                   href="#navbarVerticalGatewayMenu"
                                   role="button"
                                   data-bs-toggle="collapse"
                                   data-bs-target="#navbarVerticalGatewayMenu"
                                   aria-expanded="false"
                                   aria-controls="navbarVerticalGatewayMenu">
                                    <i class="bi-briefcase nav-icon"></i>
                                    <span class="nav-link-title"><?php echo app('translator')->get('Payment Setting'); ?></span>
                                </a>
                                <div id="navbarVerticalGatewayMenu"
                                     class="nav-collapse collapse <?php echo e(menuActive(['admin.payment.methods', 'admin.edit.payment.methods', 'admin.deposit.manual.index', 'admin.deposit.manual.create', 'admin.deposit.manual.edit'], 2)); ?>"
                                     data-bs-parent="#navbarVerticalGatewayMenu">

                                    <a class="nav-link <?php echo e(menuActive(['admin.payment.methods', 'admin.edit.payment.methods',])); ?>"
                                       href="<?php echo e(route('admin.payment.methods')); ?>"><?php echo app('translator')->get('Payment Gateway'); ?></a>

                                    <a class="nav-link <?php echo e(menuActive([ 'admin.deposit.manual.index', 'admin.deposit.manual.create', 'admin.deposit.manual.edit'])); ?>"
                                       href="<?php echo e(route('admin.deposit.manual.index')); ?>"><?php echo app('translator')->get('Manual Gateway'); ?></a>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!--
                    <div class="nav-item">
                        <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.payout.method.list','admin.payout.method.create','admin.manual.method.edit','admin.payout.method.edit','admin.payout.withdraw.days'], 3)); ?>"
                           href="#navbarVerticalWithdrawMenu"
                           role="button"
                           data-bs-toggle="collapse"
                           data-bs-target="#navbarVerticalWithdrawMenu"
                           aria-expanded="false"
                           aria-controls="navbarVerticalWithdrawMenu">
                            <i class="bi bi-wallet2 nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Withdraw Setting'); ?></span>
                        </a>
                        <div id="navbarVerticalWithdrawMenu"
                             class="nav-collapse collapse <?php echo e(menuActive(['admin.payout.method.list','admin.payout.method.create','admin.manual.method.edit','admin.payout.method.edit','admin.payout.withdraw.days'], 2)); ?>"
                             data-bs-parent="#navbarVerticalWithdrawMenu">
                            <a class="nav-link <?php echo e(menuActive(['admin.payout.method.list','admin.payout.method.create','admin.manual.method.edit','admin.payout.method.edit'])); ?>"
                               href="<?php echo e(route('admin.payout.method.list')); ?>"><?php echo app('translator')->get("Payout Methods"); ?></a>
                            <a class="nav-link <?php echo e(menuActive(['admin.payout.withdraw.days'])); ?>"
                               href="<?php echo e(route('admin.payout.withdraw.days')); ?>"><?php echo app('translator')->get("Withdraw Days"); ?></a>
                        </div>
                    </div>
                    -->


                    <?php if(adminAccessRoute('Website Management')): ?>
                        <span class="dropdown-header mt-2"><?php echo app('translator')->get("Themes Settings"); ?></span>
                        <small class="bi-three-dots nav-subtitle-replacer"></small>
                        <div class="nav-item">
                            <a class="nav-link <?php echo e(menuActive(['admin.template.all'])); ?>"
                               href="<?php echo e(route('admin.template.all')); ?>"
                               data-placement="left">
                                <i class="fa-light fa-check-square nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Choose Theme'); ?></span>
                            </a>
                        </div>
                        <div id="navbarVerticalThemeMenu">
                            <div class="nav-item">
                                <a class="nav-link <?php echo e(menuActive(['admin.page.index','admin.create.page','admin.edit.page'])); ?>"
                                   href="<?php echo e(route('admin.page.index', basicControl()->theme)); ?>"
                                   data-placement="left">
                                    <i class="fa-light fa-list nav-icon"></i>
                                    <span class="nav-link-title"><?php echo app('translator')->get('Pages'); ?></span>
                                </a>
                            </div>

                            <div class="nav-item">
                                <a class="nav-link <?php echo e(menuActive(['admin.manage.menu'])); ?>"
                                   href="<?php echo e(route('admin.manage.menu')); ?>" data-placement="left">
                                    <i class="bi-folder2-open nav-icon"></i>
                                    <span class="nav-link-title"><?php echo app('translator')->get('Manage Menu'); ?></span>
                                </a>
                            </div>
                        </div>

                        <?php
                            $segments = request()->segments();
                            $last  = end($segments);

                            $contents = config('contents');
                            $filteredContents = [];

                            foreach ($contents as $key => $value) {
                                if (isset($value['theme']) && ($value['theme'] === $basicControl->theme || $value['theme'] === 'all')) {
                                    $filteredContents[$key] = $value;
                                }
                            }
                        ?>
                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.manage.content', 'admin.manage.content.multiple', 'admin.content.item.edit*'], 3)); ?>"
                               href="#navbarVerticalContentsMenu"
                               role="button" data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalContentsMenu" aria-expanded="false"
                               aria-controls="navbarVerticalContentsMenu">
                                <i class="fa-light fa-pen nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Manage Content'); ?></span>
                            </a>
                            <div id="navbarVerticalContentsMenu"
                                 class="content-manage nav-collapse collapse <?php echo e(menuActive(['admin.manage.content', 'admin.manage.content.multiple', 'admin.content.item.edit*'], 2)); ?> "
                                 data-bs-parent="#navbarVerticalContentsMenu">
                                <?php $__currentLoopData = array_diff(array_keys($filteredContents), ['message','content_media']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $contentImage = config('contents.' . $name . '.preview');
                                    ?>
                                    <div class="contentAll d-flex justify-content-between">
                                        <a class="nav-link contentTitle <?php echo e(($last == $name) ? 'active' : ''); ?>"
                                           href="<?php echo e(route('admin.manage.content', $name)); ?>"><?php echo app('translator')->get(stringToTitle(str_replace($basicControl->theme,'', $name))); ?></a>
                                        <button class="btn btn-white btn-sm sidebarContentImage contentImage"
                                                data-image="<?php echo e(json_encode($contentImage)); ?>"
                                                data-bs-toggle="tooltip" title="Section Style">
                                            <i class="fa-regular fa-eye"></i>
                                        </button>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>


                        <div class="nav-item">
                            <a class="nav-link dropdown-toggle <?php echo e(menuActive(['admin.blog-category.index', 'admin.blog-category.create','admin.blog-category.edit', 'admin.blogs.index', 'admin.blogs.create','admin.blogs.edit*'], 3)); ?>"
                               href="#navbarVerticalBlogMenu"
                               role="button" data-bs-toggle="collapse"
                               data-bs-target="#navbarVerticalBlogMenu" aria-expanded="false"
                               aria-controls="navbarVerticalBlogMenu">
                                <i class="fa-light fa-newspaper nav-icon"></i>
                                <span class="nav-link-title"><?php echo app('translator')->get('Manage Blog'); ?></span>
                            </a>
                            <div id="navbarVerticalBlogMenu"
                                 class="nav-collapse collapse <?php echo e(menuActive(['admin.blog-category.index', 'admin.blog-category.create','admin.blog-category.edit', 'admin.blogs.index', 'admin.blogs.create','admin.blogs.edit*'], 2)); ?>"
                                 data-bs-parent="#navbarVerticalBlogMenu">
                                <a class="nav-link <?php echo e(menuActive(['admin.blog-category.index', 'admin.blog-category.create','admin.blog-category.edit'])); ?>"
                                   href="<?php echo e(route('admin.blog-category.index')); ?>"><?php echo app('translator')->get('Blog Category'); ?></a>

                                <a class="nav-link <?php echo e(menuActive(['admin.blogs.index', 'admin.blogs.create','admin.blogs.edit*'])); ?>"
                                   href="<?php echo e(route('admin.blogs.index')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>


                    <?php $__currentLoopData = collect(config('generalsettings.settings')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="nav-item d-none">
                            <a class="nav-link  <?php echo e(isMenuActive($setting['route'])); ?>"
                               href="<?php echo e(getRoute($setting['route'], $setting['route_segment'] ?? null)); ?>">
                                <i class="<?php echo e($setting['icon']); ?> nav-icon"></i>
                                <span class="nav-link-title"><?php echo e(__(getTitle($key.' '.'Settings'))); ?></span>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <span class="dropdown-header mt-2"> <?php echo app('translator')->get('Application Panel'); ?></span>
                    <small class="bi-three-dots nav-subtitle-replacer"></small>
                    <div class="nav-item">
                        <a class="nav-link <?php echo e(menuActive(['clear'])); ?>"
                           href="<?php echo e(route('clear')); ?>" data-placement="left">
                            <i class="fas fa-sync nav-icon"></i>
                            <span class="nav-link-title"><?php echo app('translator')->get('Cache Clear'); ?></span>
                        </a>
                    </div>

                </div>

                <div class="navbar-vertical-footer">
                    <ul class="navbar-vertical-footer-list">
                        <li class="navbar-vertical-footer-list-item">
                            <span class="dropdown-header"><?php echo app('translator')->get('Version 4.0'); ?></span>
                        </li>
                        <li class="navbar-vertical-footer-list-item">
                            <div class="dropdown dropup">
                                <button type="button" class="btn btn-ghost-secondary btn-icon rounded-circle"
                                        id="selectThemeDropdown" data-bs-toggle="dropdown" aria-expanded="false"
                                        data-bs-dropdown-animation></button>
                                <div class="dropdown-menu navbar-dropdown-menu navbar-dropdown-menu-borderless"
                                     aria-labelledby="selectThemeDropdown">
                                    <a class="dropdown-item" href="javascript:void(0)" data-icon="bi-moon-stars"
                                       data-value="auto">
                                        <i class="bi-moon-stars me-2"></i>
                                        <span class="text-truncate"
                                              title="Auto (system default)"><?php echo app('translator')->get("Default"); ?></span>
                                    </a>
                                    <a class="dropdown-item" href="javascript:void(0)" data-icon="bi-brightness-high"
                                       data-value="default">
                                        <i class="bi-brightness-high me-2"></i>
                                        <span class="text-truncate"
                                              title="Default (light mode)"><?php echo app('translator')->get("Light Mode"); ?></span>
                                    </a>
                                    <a class="dropdown-item active" href="javascript:void(0)" data-icon="bi-moon"
                                       data-value="dark">
                                        <i class="bi-moon me-2"></i>
                                        <span class="text-truncate" title="Dark"><?php echo app('translator')->get("Dark Mode"); ?></span>
                                    </a>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</aside>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/global/js/jquery.magnific-popup.min.js')); ?>" defer></script>

    <script>
        'use strict';
        const baseUrl = "<?php echo e(asset('')); ?>";

        function initializeMagnificPopup(imageSelector1, imageSelector2) {
            document.addEventListener('DOMContentLoaded', function () {
                const selectors = [imageSelector1, imageSelector2];
                selectors.forEach(selector => {
                    $(selector).on('click', function () {
                        let imageData = $(this).data('image');

                        let items = Object.keys(imageData).map(function (key) {
                            return {
                                src: baseUrl + imageData[key],
                                type: 'image',
                                title: key
                            };
                        });

                        $.magnificPopup.open({
                            items: items,
                            gallery: {
                                enabled: true
                            },
                            type: 'image',
                            image: {
                                titleSrc: function (item) {
                                    return `<div class="mfp-title-overlay"><h5>${item.title}</h5></div>`;
                                }
                            }
                        });
                    });
                });
            });
        }

        initializeMagnificPopup('.contentImageInside', '.sidebarContentImage');
        $(document).ready(function () {
            $.ajax({
                url: '<?php echo e(route('admin.users.search.countData')); ?>',
                type: 'GET',
                success: function (response) {
                    $('.bannedUser').text(response.banned_users);
                    $('.emailUnverified').text(response.email_unverified);
                    $('.smsUnverified').text(response.sms_unverified);
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>







<?php /**PATH C:\xampp\htdocs\nzamk\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>